--------------------------------------------------------------------------------------
-- PN2 pouvant grer jusqu' 4 voies 
--------------------------------------------------------------------------------------
-- INITIALISE
--

function Initialise ( )
	
	gInitialised = false
	gAnimState = -1
	gArmState = -1		
	
	gSignalState = OUVERT
	
	Call( "BeginUpdate" )
end
--------------------------------------------------------------------------------------
-- UPDATE
--

function Update( time )

	gInitialised = true
	
	if (gAnimState == "Clear01") then
	
		Call("*:Reset","Clear")		
		
		if Call("*:AddTime","Stop", time ) ~= 0 then
			Call( "EndUpdate" )
		end
		
	elseif (gAnimState == "Stop01") then
	
		Call("*:Reset","Stop")	
		
		if Call( "*:AddTime","Clear", time ) ~= 0 then
			Call( "EndUpdate" )
		end
		
	elseif gSignalState == OUVERT then
		NonOccupe()

	else
		Call( "EndUpdate" )		
	
	end	
end

--------------------------------------------------------------------------------------
-- RESET SIGNAL STATE
--
function ResetSignalState ( )
	
	Initialise()
	
end
--------------------------------------------------------------------------------------
-- GLOBALS

CLEAR = 0
WARNING = 1
BLOCKED = 2

RESET_SIGNAL_STATE					= 0
INITIALISE_SIGNAL_TO_BLOCKED 		= 1
JUNCTION_STATE_CHANGE				= 2
INITIALISE_TO_PREPARED				= 3

OCCUPATION_INCREMENT				= 10
OCCUPATION_DECREMENT				= 11

OUVERT								= 12
FERME								= 13

SIGNAL_CARRE						= 14
SIGNAL_VOIELIBRE					= 15
SIGNAL_AVERTISSEMENT				= 16
SIGNAL_JAUNEcli						= 17
SIGNAL_ROUGEcli						= 18
SIGNAL_SEMAPHORE                    = 19
SIGNAL_VERTcli	                    = 20
SIGNAL_R30                          = 21
SIGNAL_R60                          = 22
SIGNAL_R60JAUNEcli                  = 23
SIGNAL_RR30                         = 24
SIGNAL_RR60                         = 25
SIGNAL_RR30AVERTISSEMENT            = 26
SIGNAL_RR30JAUNEcli                 = 27
SIGNAL_RR60AVERTISSEMENT            = 28
SIGNAL_RR60JAUNEcli                 = 29
SIGNAL_AVERTISSEMENTBJ              = 30
SIGNAL_ARR30BJ						= 31
SIGNAL_DISQUE						= 32
SIGNAL_MANOEUVRE					= 33
SIGNAL_BLANCcli						= 34
SIGNAL_ETEINT						= 35
SIGNAL_GASAM						= 36

SIGNAL_MESSAGE1						= 37
SIGNAL_MESSAGE2						= 38
SIGNAL_MESSAGE3						= 39
SIGNAL_MESSAGE4						= 40
SIGNAL_MESSAGE5						= 41

PN1_Arrive							= 42
PN1_Depart							= 43
PN2_Arrive							= 44
PN2_Depart							= 45
PN3_Arrive							= 46
PN3_Depart							= 47
TIV_Ouvert							= 48
TIV_Ferme							= 49

PASS_OFFSET							= 50

PASS_RESET_SIGNAL_STATE				= PASS_OFFSET + RESET_SIGNAL_STATE	-- Never used!
PASS_JUNCTION_STATE_CHANGE			= PASS_OFFSET + JUNCTION_STATE_CHANGE
PASS_INITIALISE_SIGNAL_TO_BLOCKED 	= PASS_OFFSET + INITIALISE_SIGNAL_TO_BLOCKED 
PASS_INITIALISE_TO_PREPARED 		= PASS_OFFSET + INITIALISE_TO_PREPARED
PASS_OCCUPATION_INCREMENT			= PASS_OFFSET + OCCUPATION_INCREMENT
PASS_OCCUPATION_DECREMENT			= PASS_OFFSET + OCCUPATION_DECREMENT
PASS_SIGNAL_CARRE					= PASS_OFFSET + SIGNAL_CARRE
PASS_SIGNAL_VOIELIBRE				= PASS_OFFSET + SIGNAL_VOIELIBRE
PASS_SIGNAL_AVERTISSEMENT			= PASS_OFFSET + SIGNAL_AVERTISSEMENT
PASS_SIGNAL_JAUNEcli				= PASS_OFFSET + SIGNAL_JAUNEcli
PASS_SIGNAL_ROUGEcli				= PASS_OFFSET + SIGNAL_ROUGEcli		
PASS_SIGNAL_SEMAPHORE				= PASS_OFFSET + SIGNAL_SEMAPHORE
PASS_SIGNAL_VERTcli					= PASS_OFFSET + SIGNAL_VERTcli
PASS_SIGNAL_R30   					= PASS_OFFSET + SIGNAL_R30
PASS_SIGNAL_R60    					= PASS_OFFSET + SIGNAL_R60
PASS_SIGNAL_R60JAUNEcli				= PASS_OFFSET + SIGNAL_R60JAUNEcli
PASS_SIGNAL_RR30      				= PASS_OFFSET + SIGNAL_RR30
PASS_SIGNAL_RR60      				= PASS_OFFSET + SIGNAL_RR60
PASS_SIGNAL_RR30AVERTISSEMENT     	= PASS_OFFSET + SIGNAL_RR30AVERTISSEMENT
PASS_SIGNAL_RR30JAUNEcli			= PASS_OFFSET + SIGNAL_RR30JAUNEcli
PASS_SIGNAL_RR60AVERTISSEMENT		= PASS_OFFSET + SIGNAL_RR60AVERTISSEMENT
PASS_SIGNAL_RR60JAUNEcli			= PASS_OFFSET + SIGNAL_RR60JAUNEcli
PASS_SIGNAL_AVERTISSEMENTBJ			= PASS_OFFSET + SIGNAL_AVERTISSEMENTBJ
PASS_SIGNAL_ARR30BJ					= PASS_OFFSET + SIGNAL_ARR30BJ
PASS_SIGNAL_DISQUE					= PASS_OFFSET + SIGNAL_DISQUE
PASS_SIGNAL_MANOEUVRE				= PASS_OFFSET + SIGNAL_MANOEUVRE
PASS_SIGNAL_BLANCcli				= PASS_OFFSET + SIGNAL_BLANCcli
PASS_SIGNAL_ETEINT					= PASS_OFFSET + SIGNAL_ETEINT
PASS_SIGNAL_GASAM					= PASS_OFFSET + SIGNAL_GASAM

gConnectedLink = 0
gUpdating = 0

AWS_MESSAGE								= 11
TPWS_MESSAGE							= 12
SPAD_MESSAGE							= 13
CROCO_MESSAGE 							= 14

gCompteur = 0
gVoie1 = 0
gVoie2 = 0
gVoie3 = 0
gVoie4 = 0
--------------------------------------------------------------------------------------
-- JUNCTION STATE CHANGE
---

function OnJunctionStateChange( junction_state, parameter, direction, linkIndex )

end
--------------------------------------------------------------------------------------
-- ON CONSIST PASS
--
function OnConsistPass ( prevFrontDist, prevBackDist, frontDist, backDist, linkIndex )

end
----------------------------------------------------------------------------------
-- OCCUPE
--
function Occupe( linkIndex )

	if gSignalState ~= FERME then
	
		SetState( FERME )
	end

end
--------------------------------------------------------------------------------------
-- NONOCCUPE
--
function NonOccupe( linkIndex )

	if gSignalState ~= OUVERT then
	
		SetState( OUVERT )
	end

end
--------------------------------------------------------------------------------------
-- SET STATE
--

function SetState( newState )
	
   if (newState == OUVERT) then

			gAnimState = "Clear01"
			Call("BeginUpdate")


    elseif (newState == FERME) then


			gAnimState = "Stop01"
			Call("BeginUpdate")

	end

gSignalState = newState

end
--------------------------------------------------------------------------------------
-- ON SIGNAL MESSAGE
--

function OnSignalMessage( message, parameter, direction, linkIndex )

	if (message == RESET_SIGNAL_STATE) then
	
		ResetSignalState()
		
	elseif (direction == -1) and (linkIndex == 0) then

		if (message == PN2_Arrive) then

			if gVoie1 == 0 then

				gVoie1 = gVoie1 + 1
					
			else
				
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end
		
			Call( "SendSignalMessage", PN2_Arrive, "", 1, 1, 0 )

		elseif (message == PN2_Depart) then

			if gVoie1 > 0 then

				gVoie1 = gVoie1 - 1	
			
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end		
	
			Call( "SendSignalMessage", PN2_Depart, "", 1, 1, 0 )	

		else
		
			Call( "SendSignalMessage", message, "", 1, 1, 0 )

		end						

	elseif (direction == -1) and (linkIndex == 1) then

		if (message == PN2_Arrive) then

			if gVoie2 == 0 then

				gVoie2 = gVoie2 + 1
					
			else
				
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end
		
			Call( "SendSignalMessage", PN2_Arrive, "", 1, 1, 1 )				

		elseif (message == PN2_Depart) then

			if gVoie2 > 0 then

				gVoie2 = gVoie2 - 1	
			
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end	

			Call( "SendSignalMessage", PN2_Depart, "", 1, 1, 1 )

		else
		
			Call( "SendSignalMessage", message, "", 1, 1, 1 )

		end			

	elseif (direction == -1) and (linkIndex == 2) then

		if (message == PN2_Arrive) then

			if gVoie3 == 0 then

				gVoie3 = gVoie3 + 1
					
			else
				
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end
		
			Call( "SendSignalMessage", PN2_Arrive, "", 1, 1, 2 )				

		elseif (message == PN2_Depart) then

			if gVoie3 > 0 then

				gVoie3 = gVoie3 - 1	
			
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end	

			Call( "SendSignalMessage", PN2_Depart, "", 1, 1, 2)	
			
		else
		
			Call( "SendSignalMessage", message, "", 1, 1, 2)

		end						

	elseif (direction == -1) and (linkIndex == 3) then

		if (message == PN2_Arrive) then

			if gVoie4 == 0 then

				gVoie4 = gVoie4 + 1
					
			else
				
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end
		
			Call( "SendSignalMessage", PN2_Arrive, "", 1, 1, 3 )				

		elseif (message == PN2_Depart) then

			if gVoie4 > 0 then

				gVoie4 = gVoie4 - 1	
			
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end	

			Call( "SendSignalMessage", PN2_Depart, "", 1, 1, 3)	
			
		else
		
			Call( "SendSignalMessage", message, "", 1, 1, 3)

		end						

	elseif (direction == 1) and (linkIndex == 0) then			
			
		if (message == PN2_Arrive) then

			if gVoie1 == 0 then

				gVoie1 = gVoie1 + 1
					
			else
				
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end	

			Call( "SendSignalMessage", PN2_Arrive, "", -1, 1, 0 )						
			
		elseif (message == PN2_Depart) then

			if gVoie1 > 0 then

				gVoie1 = gVoie1 - 1	
			
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end
		
			Call( "SendSignalMessage", PN2_Depart, "", -1, 1, 0 )	

		else
		
			Call( "SendSignalMessage", message, "", -1, 1, 0 )					
			
		end
			
	elseif (direction == 1) and (linkIndex == 1) then				
		
		if (message == PN2_Arrive) then

			if gVoie2 == 0 then

				gVoie2 = gVoie2 + 1
					
			else
				
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end	

			Call( "SendSignalMessage", PN2_Arrive, "", -1, 1, 1 )						
	
		elseif (message == PN2_Depart) then

			if gVoie2 > 0 then

				gVoie2 = gVoie2 - 1	
			
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end	

			Call( "SendSignalMessage", PN2_Depart, "", -1, 1, 1 )			

		else
		
			Call( "SendSignalMessage", message, "", -1, 1, 1 )					
			
		end		
		
	elseif (direction == 1) and (linkIndex == 2) then		
		
		if (message == PN2_Arrive) then

			if gVoie3 == 0 then

				gVoie3 = gVoie3 + 1
					
			else
				
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end	

			Call( "SendSignalMessage", PN2_Arrive, "", -1, 1, 2 )			
		
		elseif (message == PN2_Depart) then

			if gVoie3 > 0 then

				gVoie3 = gVoie3 - 1	
			
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end	

			Call( "SendSignalMessage", PN2_Depart, "", -1, 1, 2 )		
		
		else
		
			Call( "SendSignalMessage", message, "", -1, 1, 2 )					
			
		end

	elseif (direction == 1) and (linkIndex == 3) then		
		
		if (message == PN2_Arrive) then

			if gVoie4 == 0 then

				gVoie4 = gVoie4 + 1
					
			else
				
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end	

			Call( "SendSignalMessage", PN2_Arrive, "", -1, 1, 3 )			
		
		elseif (message == PN2_Depart) then

			if gVoie4 > 0 then

				gVoie4 = gVoie4 - 1	
			
			end
		
			gCompteur = gVoie1 + gVoie2 + gVoie3 + gVoie4
		
			if gCompteur > 0 then
			
				Occupe()
				
			else

				NonOccupe()					
				
			end	

			Call( "SendSignalMessage", PN2_Depart, "", -1, 1, 3 )		
		
		else
		
			Call( "SendSignalMessage", message, "", -1, 1, 3 )					
			
		end			

	end

end





